VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "DPC_BOR"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public BOR_AplIdentNr As String
Public BOR_Id As Long
Public BOR_Pos As Long
Public BOR_Categ As eDPCBOROperation
Public BOR_CategDesc As String
Public BOR_StagNr As String
Public BOR_AgId As Long
Public BOR_Name As String
Public BOR_KostSt As Long
Public BOR_Mate As String
Public BOR_Te As Double
Public BOR_Matr As String
Public BOR_Tr As Double
Public BOR_Brtr As Double
Public BOR_Lgtr As Double
Public BOR_Lgrp As Long
Public BOR_La As Long
Public BOR_ArbPlatz As String
Public BOR_Agbs As String
Public BOR_Konto As Long  'fremdfertigung konto
Public BOR_Agben_Fremd As String
Public BOR_Kurzben As String
Public BOR_Anz_Bedien As Long
Public BOR_Genau As String
Public BOR_Mauez As String
Public BOR_Lhs As Long
Public BOR_Mehrm As Double
Public BOR_Trko As Double ' fremdfertigund
Public BOR_Teko As Double ' fremdfertigung
Public BOR_Frzeit As Long
Public BOR_Mind_Gut As Double
Public BOR_Kz_kannag As String
Public BOR_Agmenge As Double

Public BOR_VarPerFact As Double
Public BOR_VarMasFact As Double
'Public BOR_VarPerCost As Double  ' property
'Public BOR_VarMasCost As Double  ' property
Public BOR_OutsrcCost As Double  ' unused
'Public BOR_DirectCost As Double   'property

Public BOR_FixMasFact As Double
'Public BOR_FixMasCost As Double   'property

'new fields !!!
Public BOR_CostCalcMPE2 As Double   'comes from calculation of cost for BOM/BOR - MPE2 value
Public BOR_VarSetupFact As Double
Public BOR_FixSetupFact As Double
'BOR_DirectSetupCost property
'BOR_SubtotalSetupCost property
'BOR_TotSetupCost property

'BOR_DirectWidSetupCost property
'BOR_SubtotalWidSetupCost property
'BOR_TotWidSetupCost property

'BOR_DirectLenSetupCost property
'BOR_SubtotalLenSetupCost property
'BOR_TotLenSetupCost property

'end new fields

Public BOR_WasteFact As Double
'Public BOR_WasteCost As Double ' property
'Public BOR_Cost As Double  'property

Public CURR_Code As String
Public BOR_Speed As Long  ' unused
Public BOR_Status As eDPCBOMBORStatus
Public BOR_StatusDesc As String
Public BOR_Manual As Boolean
Public BOR_WghPnt As Long

Public BOR_Cost As Double ' unused ???????? move to correct position
'Public BOR_TotCost As Double ' unused ???????? move to correct position

Public Idx As Long
Public RowStatus As eDPCRowStatus

'#If LIVE = 1 Then
'  Private mo_Db As Object
'  Private mo_FSO As Object
'#Else
'  Private mo_Db As ARMSYSCOMLib.ArmDb
'  Private mo_FSO As FileSystemObject
'#End If

Private mo_Tools As DPC_Tools

Private Const C_ERRORRAISE As Long = 2500
Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

'Public Property Set ArmDb(ByRef lo_Db As Object)
'  If Not (lo_Db Is Nothing) Then
'      Set mo_Db = lo_Db
'  End If
'End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Public Sub Clear()
On Error GoTo ErrHandler

  BOR_StagNr = ""
  BOR_AgId = 0
  BOR_Name = ""
  BOR_KostSt = 0
  BOR_Te = 0
  BOR_Tr = 0
  BOR_Brtr = 0
  BOR_Lgtr = 0
  BOR_Lgrp = 0
  BOR_Anz_Bedien = 0
  BOR_VarPerFact = 0
  CURR_Code = ""
  BOR_Speed = 0
  BOR_Status = eDPCBOMBORStatus.boNone
  BOR_StatusDesc = ""
  
  BOR_Mate = ""
  BOR_Matr = ""
  BOR_La = 0
  BOR_ArbPlatz = ""
  BOR_Agbs = ""
  BOR_Konto = 0
  BOR_Agben_Fremd = ""
  BOR_Kurzben = ""
  BOR_Genau = ""
  BOR_Mauez = ""
  BOR_Lhs = 0
  BOR_Mehrm = 0
  BOR_Trko = 0
  BOR_Teko = 0
  BOR_Frzeit = 0
  BOR_Mind_Gut = 0
  BOR_Kz_kannag = ""
  BOR_Agmenge = 0
  BOR_Manual = False
  BOR_WghPnt = 0

  Exit Sub
ErrHandler:
  Call ErrorHandler("Clear")
End Sub

Public Sub CopyFrom(ByVal ao_BOR As DPC_BOR)
On Error GoTo ErrHandler

  BOR_AplIdentNr = ao_BOR.BOR_AplIdentNr
  BOR_Id = ao_BOR.BOR_Id
  BOR_Categ = ao_BOR.BOR_Categ
  BOR_CategDesc = ao_BOR.BOR_CategDesc
  BOR_StagNr = ao_BOR.BOR_StagNr
  BOR_AgId = ao_BOR.BOR_AgId
  BOR_Name = ao_BOR.BOR_Name
  BOR_KostSt = ao_BOR.BOR_KostSt
  BOR_Te = ao_BOR.BOR_Te
  BOR_Tr = ao_BOR.BOR_Tr
  BOR_Brtr = ao_BOR.BOR_Brtr
  BOR_Lgtr = ao_BOR.BOR_Lgtr
  BOR_Lgrp = ao_BOR.BOR_Lgrp
  BOR_Anz_Bedien = ao_BOR.BOR_Anz_Bedien
  CURR_Code = ao_BOR.CURR_Code
  BOR_Speed = ao_BOR.BOR_Speed
  BOR_Status = ao_BOR.BOR_Status
  BOR_StatusDesc = ao_BOR.BOR_StatusDesc

  BOR_Mate = ao_BOR.BOR_Mate
  BOR_Matr = ao_BOR.BOR_Matr
  BOR_La = ao_BOR.BOR_La
  BOR_ArbPlatz = ao_BOR.BOR_ArbPlatz
  BOR_Agbs = ao_BOR.BOR_Agbs
  BOR_Konto = ao_BOR.BOR_Konto
  BOR_Agben_Fremd = ao_BOR.BOR_Agben_Fremd
  BOR_Kurzben = ao_BOR.BOR_Kurzben
  BOR_Genau = ao_BOR.BOR_Genau
  BOR_Mauez = ao_BOR.BOR_Mauez
  BOR_Lhs = ao_BOR.BOR_Lhs
  BOR_Mehrm = ao_BOR.BOR_Mehrm
  BOR_Trko = ao_BOR.BOR_Trko
  BOR_Teko = ao_BOR.BOR_Teko
  BOR_Frzeit = ao_BOR.BOR_Frzeit
  BOR_Mind_Gut = ao_BOR.BOR_Mind_Gut
  BOR_Kz_kannag = ao_BOR.BOR_Kz_kannag
  BOR_Agmenge = ao_BOR.BOR_Agmenge
  BOR_Manual = ao_BOR.BOR_Manual
  BOR_WghPnt = ao_BOR.BOR_WghPnt
  
  BOR_VarPerFact = ao_BOR.BOR_VarPerFact
  BOR_VarMasFact = ao_BOR.BOR_VarMasFact
  BOR_OutsrcCost = ao_BOR.BOR_CostCalcMPE2
  BOR_FixMasFact = ao_BOR.BOR_FixMasFact
  BOR_CostCalcMPE2 = ao_BOR.BOR_CostCalcMPE2
  BOR_VarSetupFact = ao_BOR.BOR_VarSetupFact
  BOR_FixSetupFact = ao_BOR.BOR_FixSetupFact
  BOR_WasteFact = ao_BOR.BOR_WasteFact
  BOR_Cost = ao_BOR.BOR_Cost
  
  Idx = ao_BOR.Idx
  Exit Sub
ErrHandler:
  Call ErrorHandler("CopyFrom")
End Sub

Public Sub InitCostParameters(ByVal ao_Product As DPC_Product)
On Error GoTo ErrHandler

  BOR_WasteFact = ao_Product.RPL_BORWasteFact
  BOR_CostCalcMPE2 = ao_Product.RPL_MPE2Fact
  Exit Sub
ErrHandler:
  Call ErrorHandler("InitCostParameters")
End Sub

Public Property Get BOR_VarPerCost() As Double
On Error GoTo ErrHandler
  
  BOR_VarPerCost = BOR_Anz_Bedien * BOR_Te * BOR_VarPerFact
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_VarPerCost")
End Property

Public Property Get BOR_VarMasCost() As Double
On Error GoTo ErrHandler
  
  BOR_VarMasCost = BOR_Te * BOR_VarMasFact
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_VarMasCost")
End Property

Public Property Get BOR_DirectCost() As Double
On Error GoTo ErrHandler
  
  BOR_DirectCost = BOR_Anz_Bedien * BOR_Te * BOR_VarPerFact + BOR_Te * BOR_VarMasFact + BOR_Teko
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_DirectCost")
End Property

Public Property Get BOR_FixMasCost() As Double
On Error GoTo ErrHandler
  
  BOR_FixMasCost = BOR_Te * BOR_FixMasFact
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_FixMasCost")
End Property

Public Property Get BOR_WasteCost() As Double
On Error GoTo ErrHandler
  
  BOR_WasteCost = (BOR_VarMasCost + BOR_VarPerCost + BOR_Teko + BOR_FixMasCost) * BOR_WasteFact
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_WasteCost")
End Property

'--------------- BASIC SETUP COST CALCULATION

Public Property Get BOR_VarSetupCost() As Double
On Error GoTo ErrHandler
  
  BOR_VarSetupCost = BOR_Tr * BOR_VarSetupFact
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_VarSetupCost")
End Property

Public Property Get BOR_FixSetupCost() As Double
On Error GoTo ErrHandler
  
  BOR_FixSetupCost = BOR_Tr * BOR_FixSetupFact
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_FixSetupCost")
End Property

Public Property Get BOR_DirectSetupCost() As Double
On Error GoTo ErrHandler
  
  BOR_DirectSetupCost = BOR_VarSetupCost + BOR_FixSetupCost + BOR_Trko
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_DirectSetupCost")
End Property

Public Property Get BOR_FixMasSetupCost() As Double  'MPE1
On Error GoTo ErrHandler
  
  BOR_FixMasSetupCost = BOR_Tr * BOR_FixMasFact
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_FixMasSetupCost")
End Property

Public Property Get BOR_SubtotalSetupCost() As Double
On Error GoTo ErrHandler
  
  BOR_SubtotalSetupCost = BOR_DirectSetupCost + BOR_FixMasSetupCost
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_SubtotalSetupCost")
End Property

Public Property Get BOR_MPE2SetupCost() As Double
On Error GoTo ErrHandler
  
  BOR_MPE2SetupCost = BOR_SubtotalSetupCost * BOR_CostCalcMPE2
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_MPE2SetupCost")
End Property

Public Property Get BOR_TotSetupCost() As Double
On Error GoTo ErrHandler
  
  BOR_TotSetupCost = BOR_SubtotalSetupCost + BOR_MPE2SetupCost
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_TotSetupCost")
End Property

'--------------- WIDTH SETUP COST CALCULATION

Public Property Get BOR_VarWidSetupCost() As Double
On Error GoTo ErrHandler
  
  BOR_VarWidSetupCost = BOR_Brtr * BOR_VarSetupFact
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_VarWidSetupCost")
End Property

Public Property Get BOR_FixWidSetupCost() As Double
On Error GoTo ErrHandler
  
  BOR_FixWidSetupCost = BOR_Brtr * BOR_FixSetupFact
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_FixWidSetupCost")
End Property

Public Property Get BOR_DirectWidSetupCost() As Double
On Error GoTo ErrHandler
  
  BOR_DirectWidSetupCost = BOR_VarWidSetupCost + BOR_FixWidSetupCost
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_DirectWidSetupCost")
End Property

Public Property Get BOR_FixMasWidSetupCost() As Double  'MPE1
On Error GoTo ErrHandler
  
  BOR_FixMasWidSetupCost = BOR_Brtr * BOR_FixMasFact
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_FixMasWidSetupCost")
End Property

Public Property Get BOR_SubtotalWidSetupCost() As Double
On Error GoTo ErrHandler
  
  BOR_SubtotalWidSetupCost = BOR_DirectWidSetupCost + BOR_FixMasWidSetupCost
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_SubtotalWidSetupCost")
End Property

Public Property Get BOR_MPE2WidSetupCost() As Double
On Error GoTo ErrHandler
  
  BOR_MPE2WidSetupCost = BOR_SubtotalWidSetupCost * BOR_CostCalcMPE2
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_MPE2WidSetupCost")
End Property

Public Property Get BOR_TotWidSetupCost() As Double
On Error GoTo ErrHandler
  
  BOR_TotWidSetupCost = BOR_SubtotalWidSetupCost + BOR_MPE2WidSetupCost
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_TotWidSetupCost")
End Property

'--------------- LENGTH SETUP COST CALCULATION

Public Property Get BOR_VarLenSetupCost() As Double
On Error GoTo ErrHandler
  
  BOR_VarLenSetupCost = BOR_Lgtr * BOR_VarSetupFact
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_VarLenSetupCost")
End Property

Public Property Get BOR_FixLenSetupCost() As Double
On Error GoTo ErrHandler
  
  BOR_FixLenSetupCost = BOR_Lgtr * BOR_FixSetupFact
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_FixLenSetupCost")
End Property

Public Property Get BOR_DirectLenSetupCost() As Double
On Error GoTo ErrHandler
  
  BOR_DirectLenSetupCost = BOR_VarLenSetupCost + BOR_FixLenSetupCost
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_DirectLenSetupCost")
End Property

Public Property Get BOR_FixMasLenSetupCost() As Double  'MPE1
On Error GoTo ErrHandler
  
  BOR_FixMasLenSetupCost = BOR_Lgtr * BOR_FixMasFact
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_FixMasLenSetupCost")
End Property

Public Property Get BOR_SubtotalLenSetupCost() As Double
On Error GoTo ErrHandler
  
  BOR_SubtotalLenSetupCost = BOR_DirectLenSetupCost + BOR_FixMasLenSetupCost
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_SubtotalLenSetupCost")
End Property

Public Property Get BOR_MPE2LenSetupCost() As Double
On Error GoTo ErrHandler
  
  BOR_MPE2LenSetupCost = BOR_SubtotalLenSetupCost * BOR_CostCalcMPE2
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_MPE2LenSetupCost")
End Property

Public Property Get BOR_TotLenSetupCost() As Double
On Error GoTo ErrHandler
  
  BOR_TotLenSetupCost = BOR_SubtotalLenSetupCost + BOR_MPE2LenSetupCost
  Exit Property
ErrHandler:
  Call ErrorHandler("BOR_TotLenSetupCost")
End Property

'----------------------------------------------------------- END SETUP COSTS

Public Sub ReadBOR(ByVal ao_Db As Object, ByVal ac_Cursor As Long)
On Error GoTo ErrHandler

  BOR_Id = ao_Db.GetFields(ac_Cursor, "BOR_Id")
  BOR_AplIdentNr = ao_Db.GetFields(ac_Cursor, "BOR_AplIdentNr")
  BOR_Pos = ao_Db.GetFields(ac_Cursor, "BOR_Pos")
  BOR_Categ = ao_Db.GetFields(ac_Cursor, "BOR_Categ")
  BOR_CategDesc = ao_Db.GetFields(ac_Cursor, "BOR_CategDesc")
  BOR_StagNr = ao_Db.GetFields(ac_Cursor, "BOR_StagNr")
  BOR_AgId = ao_Db.GetFields(ac_Cursor, "BOR_AgId")
  BOR_Name = ao_Db.GetFields(ac_Cursor, "BOR_Name")
  BOR_KostSt = ao_Db.GetFields(ac_Cursor, "BOR_KostSt")
  BOR_Tr = ao_Db.GetFields(ac_Cursor, "BOR_Tr")
  BOR_Brtr = ao_Db.GetFields(ac_Cursor, "BOR_Brtr")
  BOR_Lgtr = ao_Db.GetFields(ac_Cursor, "BOR_Lgtr")
  BOR_Te = ao_Db.GetFields(ac_Cursor, "BOR_Te")
  BOR_Lgrp = ao_Db.GetFields(ac_Cursor, "BOR_Lgrp")
  BOR_Anz_Bedien = ao_Db.GetFields(ac_Cursor, "BOR_Anz_Bedien")
  BOR_VarPerFact = ao_Db.GetFields(ac_Cursor, "BOR_VarPerFact")
  
  BOR_CostCalcMPE2 = ao_Db.GetFields(ac_Cursor, "BOR_CostCalcMPE2")
  BOR_VarSetupFact = ao_Db.GetFields(ac_Cursor, "BOR_VarSetupFact")
  BOR_FixSetupFact = ao_Db.GetFields(ac_Cursor, "BOR_FixSetupFact")
  
  BOR_FixMasFact = ao_Db.GetFields(ac_Cursor, "BOR_FixMasFact")
  BOR_VarMasFact = ao_Db.GetFields(ac_Cursor, "BOR_VarMasFact")
  
  BOR_OutsrcCost = ao_Db.GetFields(ac_Cursor, "BOR_OutsrcCost")
  BOR_WasteFact = ao_Db.GetFields(ac_Cursor, "BOR_WasteFact")
  
  BOR_Cost = ao_Db.GetFields(ac_Cursor, "BOR_Cost")
  'BOR_TotCost = ao_Db.GetFields(ac_Cursor, "BOR_TotCost")
  CURR_Code = ao_Db.GetFields(ac_Cursor, "CURR_Code")
  BOR_Speed = ao_Db.GetFields(ac_Cursor, "BOR_Speed")
  BOR_Status = ao_Db.GetFields(ac_Cursor, "BOR_Status")
  BOR_StatusDesc = ao_Db.GetFields(ac_Cursor, "BOR_StatusDesc")
  
  BOR_Mate = ao_Db.GetFields(ac_Cursor, "BOR_Mate")
  BOR_Matr = ao_Db.GetFields(ac_Cursor, "BOR_Matr")
  BOR_La = ao_Db.GetFields(ac_Cursor, "BOR_La")
  BOR_ArbPlatz = ao_Db.GetFields(ac_Cursor, "BOR_ArbPlatz")
  BOR_Agbs = ao_Db.GetFields(ac_Cursor, "BOR_Agbs")
  BOR_Konto = ao_Db.GetFields(ac_Cursor, "BOR_Konto")
  BOR_Agben_Fremd = ao_Db.GetFields(ac_Cursor, "BOR_Agben_Fremd")
  BOR_Kurzben = ao_Db.GetFields(ac_Cursor, "BOR_Kurzben")
  BOR_Genau = ao_Db.GetFields(ac_Cursor, "BOR_Genau")
  BOR_Mauez = ao_Db.GetFields(ac_Cursor, "BOR_Mauez")
  BOR_Lhs = ao_Db.GetFields(ac_Cursor, "BOR_Lhs")
  BOR_Mehrm = ao_Db.GetFields(ac_Cursor, "BOR_Mehrm")
  BOR_Trko = ao_Db.GetFields(ac_Cursor, "BOR_Trko")
  BOR_Teko = ao_Db.GetFields(ac_Cursor, "BOR_Teko")
  BOR_Frzeit = ao_Db.GetFields(ac_Cursor, "BOR_Frzeit")
  BOR_Mind_Gut = ao_Db.GetFields(ac_Cursor, "BOR_Mind_Gut")
  BOR_Kz_kannag = ao_Db.GetFields(ac_Cursor, "BOR_Kz_kannag")
  BOR_Agmenge = ao_Db.GetFields(ac_Cursor, "BOR_Agmenge")
  BOR_Manual = StrComp(ao_Db.GetFields(ac_Cursor, "BOR_Manual"), "X", vbTextCompare) = 0
  BOR_WghPnt = ao_Db.GetFields(ac_Cursor, "BOR_WghPnt")
  Exit Sub
ErrHandler:
  Call ErrorHandler("ReadBOR")
End Sub

Public Function LoadBORTimeFromBaeurer(ByVal ao_DbBaeurer As Object, ByVal ao_Product As DPC_Product) As Boolean
On Error GoTo ErrHandler

Dim ls_Request As String
Dim lc_Cursor As Long

  LoadBORTimeFromBaeurer = False
  ls_Request = "SELECT TOP 1 te,tr,lgtr,brtr,laenge,breite " & _
              "FROM fa211 " & _
              "WHERE " & _
              "fi_nr=1 AND " & _
              "kostst=$BOR_KostSt$ AND " & _
              "stagnr=$BOR_StagNr$ AND " & _
              "ROUND(laenge,2)>=$RPL_PanA$ AND " & _
              "ROUND(breite,2)>=$RPL_PanB$ " & _
              "ORDER BY laenge,breite"
  ls_Request = Replace(ls_Request, "$BOR_KostSt$", mo_Tools.SqlInt(BOR_KostSt), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$BOR_StagNr$", mo_Tools.SQLStr(BOR_StagNr), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$RPL_PanA$", mo_Tools.SqlDbl(ao_Product.RPL_PanA), , , vbTextCompare)
  ls_Request = Replace(ls_Request, "$RPL_PanB$", mo_Tools.SqlDbl(ao_Product.RPL_PanB), , , vbTextCompare)
  lc_Cursor = mo_Tools.OpenSQLSafe(ao_DbBaeurer, ls_Request)
  If ao_DbBaeurer.RowCount(lc_Cursor) = 1 Then
    Call ReadBORTimeFromBaeurer(ao_DbBaeurer, lc_Cursor)
    LoadBORTimeFromBaeurer = True
  End If
  Call ao_DbBaeurer.Close(lc_Cursor)
  Exit Function
ErrHandler:
  Call ErrorHandler("LoadBORTimeFromBaeurer")
End Function

Public Function LoadBORFromBaeurer(ByVal ao_DbBaeurer As Object, ByVal al_AgId As Long, Optional ByVal as_StAgNr As String = "") As Boolean
On Error GoTo ErrHandler

Dim ls_Request As String
Dim lc_Cursor As Long
Dim ls_Operation As String
Dim ls_Name As String

  LoadBORFromBaeurer = False
  'Call Clear
  If (al_AgId > 0) Or (as_StAgNr <> "") Then
    ls_Request = "SELECT f250.agid,f250.stagnr,f250.kostst,f250.lgrp,f250.anz_bedien,f250.agben,f250.kurzben,f250.matr,f250.mate,f250.la,f250.arbplatz,f250.agbs," & _
                "f250.konto,f250.agben_fremd,f250.genau,f250.mauez,f250.lhs,f250.mehrm,f250.trko,f250.teko,f250.frzeit,f250.mind_gut,f250.kz_kannag,f250.agmenge," & _
                "f310.ks_varmas, f310.ks_varper, f310.ks_fixmas, f310.ks_varrue, f310.ks_fixrue  " & _
                "FROM f250 " & _
                "LEFT JOIN f310 ON (f310.fi_nr=f250.fi_nr AND f310.kostst=f250.kostst AND f310.arbplatz=f250.arbplatz AND f310.lgrp=f250.lgrp) " & _
                "WHERE (f250.agid=$agid$ OR $agid$ IS NULL) AND " & _
                "(f250.stagnr=$stagnr$ OR $stagnr$ IS NULL) AND " & _
                "f250.fi_nr=1"
    ls_Request = Replace(ls_Request, "$agid$", mo_Tools.SqlIntKey(al_AgId), , , vbTextCompare)
    ls_Request = Replace(ls_Request, "$stagnr$", mo_Tools.SqlStrKey(as_StAgNr), , , vbTextCompare)
    lc_Cursor = mo_Tools.OpenSQLSafe(ao_DbBaeurer, ls_Request)
    If ao_DbBaeurer.RowCount(lc_Cursor) = 1 Then
      Call ReadBORFromBaeurer(ao_DbBaeurer, lc_Cursor)
      BOR_Status = eDPCBOMBORStatus.boGeneratedOK
      LoadBORFromBaeurer = True
    Else
      BOR_Status = eDPCBOMBORStatus.boGeneratedError
    End If
    Call ao_DbBaeurer.Close(lc_Cursor)
  Else
    BOR_Status = eDPCBOMBORStatus.boGeneratedError
  End If
  Exit Function
ErrHandler:
  Call ErrorHandler("LoadBORFromBaeurer")
End Function

Public Sub ReadBORFromBaeurer(ByVal ao_DbBaeurer As Object, ByVal ac_Cursor As Long)
On Error GoTo ErrHandler

  BOR_StagNr = ao_DbBaeurer.GetFields(ac_Cursor, "stagnr")
  BOR_AgId = ao_DbBaeurer.GetFields(ac_Cursor, "agid")
  BOR_KostSt = ao_DbBaeurer.GetFields(ac_Cursor, "kostst")
  BOR_Lgrp = ao_DbBaeurer.GetFields(ac_Cursor, "lgrp")
  BOR_Anz_Bedien = ao_DbBaeurer.GetFields(ac_Cursor, "anz_bedien")
  BOR_Name = BOR_StagNr & ": " & ao_DbBaeurer.GetFields(ac_Cursor, "agben")
  
  BOR_Mate = ao_DbBaeurer.GetFields(ac_Cursor, "mate")
  BOR_Matr = ao_DbBaeurer.GetFields(ac_Cursor, "matr")
  BOR_La = ao_DbBaeurer.GetFields(ac_Cursor, "la")
  BOR_ArbPlatz = ao_DbBaeurer.GetFields(ac_Cursor, "arbplatz")
  BOR_Agbs = ao_DbBaeurer.GetFields(ac_Cursor, "agbs")
  BOR_Konto = ao_DbBaeurer.GetFields(ac_Cursor, "konto")
  BOR_Agben_Fremd = ao_DbBaeurer.GetFields(ac_Cursor, "agben_fremd")
  BOR_Kurzben = ao_DbBaeurer.GetFields(ac_Cursor, "kurzben")
  BOR_Genau = ao_DbBaeurer.GetFields(ac_Cursor, "genau")
  BOR_Mauez = ao_DbBaeurer.GetFields(ac_Cursor, "mauez")
  BOR_Lhs = ao_DbBaeurer.GetFields(ac_Cursor, "lhs")
  BOR_Mehrm = ao_DbBaeurer.GetFields(ac_Cursor, "mehrm")
  BOR_Trko = ao_DbBaeurer.GetFields(ac_Cursor, "trko")
  BOR_Teko = ao_DbBaeurer.GetFields(ac_Cursor, "teko")
  BOR_Frzeit = ao_DbBaeurer.GetFields(ac_Cursor, "frzeit")
  BOR_Mind_Gut = ao_DbBaeurer.GetFields(ac_Cursor, "mind_gut")
  BOR_Kz_kannag = ao_DbBaeurer.GetFields(ac_Cursor, "kz_kannag")
  BOR_Agmenge = ao_DbBaeurer.GetFields(ac_Cursor, "agmenge")
  
  BOR_VarPerFact = ao_DbBaeurer.GetFields(ac_Cursor, "ks_varper")
  BOR_VarMasFact = ao_DbBaeurer.GetFields(ac_Cursor, "ks_varmas")
  BOR_FixMasFact = ao_DbBaeurer.GetFields(ac_Cursor, "ks_fixmas")
  BOR_VarSetupFact = ao_DbBaeurer.GetFields(ac_Cursor, "ks_varrue")
  BOR_FixSetupFact = ao_DbBaeurer.GetFields(ac_Cursor, "ks_fixrue")
  'TODO check if generate ok and currency from config
  CURR_Code = "EUR"
  Exit Sub
ErrHandler:
  Call ErrorHandler("ReadBORFromBaeurer")
End Sub

Public Sub ReadBORTimeFromBaeurer(ByVal ao_DbBaeurer As Object, ByVal ac_Cursor As Long)
On Error GoTo ErrHandler

  If ao_DbBaeurer.RowCount(ac_Cursor) = 1 Then
    BOR_Te = ao_DbBaeurer.GetFields(ac_Cursor, "te")
    BOR_Tr = ao_DbBaeurer.GetFields(ac_Cursor, "tr")
    BOR_Lgtr = ao_DbBaeurer.GetFields(ac_Cursor, "lgtr")
    BOR_Brtr = ao_DbBaeurer.GetFields(ac_Cursor, "brtr")
  Else
    BOR_Te = 0
    BOR_Tr = 0
    BOR_Lgtr = 0
    BOR_Brtr = 0
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("ReadBORTimeFromBaeurer")
End Sub

Public Function ReplaceValuePlaceholder(ByVal as_Text As String) As String
On Error GoTo ErrHandler

  as_Text = Replace(as_Text, "$BOR_AplIdentNr$", BOR_AplIdentNr, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Id$", BOR_Id, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Pos$", BOR_Pos, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Categ$", BOR_Categ, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_CategDesc$", BOR_CategDesc, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_StagNr$", BOR_StagNr, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_AgId$", BOR_AgId, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Name$", BOR_Name, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_KostSt$", BOR_KostSt, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Te$", mo_Tools.DblToScreen(BOR_Te, 2), , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Tr$", mo_Tools.DblToScreen(BOR_Tr, 2), , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Brtr$", mo_Tools.DblToScreen(BOR_Brtr, 2), , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Lgtr$", mo_Tools.DblToScreen(BOR_Lgtr, 2), , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Lgrp$", BOR_Lgrp, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Anz_Bedien$", BOR_Anz_Bedien, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_VarPerFact$", mo_Tools.DblToScreen(BOR_VarPerFact, 2), , , vbTextCompare)
  as_Text = Replace(as_Text, "$CURR_Code$", CURR_Code, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Speed$", BOR_Speed, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Status$", BOR_Status, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_StatusDesc$", BOR_StatusDesc, , , vbTextCompare)

  as_Text = Replace(as_Text, "$BOR_Mate$", BOR_Mate, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Matr$", BOR_Matr, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_La$", BOR_La, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_ArbPlatz$", BOR_ArbPlatz, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Agbs$", BOR_Agbs, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Konto$", BOR_Konto, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Agben_Fremd$", BOR_Agben_Fremd, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Kurzben$", BOR_Kurzben, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Genau$", BOR_Genau, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Mauez$", BOR_Mauez, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Lhs$", BOR_Lhs, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Mehrm$", mo_Tools.DblToScreen(BOR_Mehrm, 2), , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Trko$", mo_Tools.DblToScreen(BOR_Trko, 2), , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Teko$", mo_Tools.DblToScreen(BOR_Teko, 2), , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Frzeit$", BOR_Frzeit, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Mind_Gut$", mo_Tools.DblToScreen(BOR_Mind_Gut, 2), , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Kz_kannag$", BOR_Kz_kannag, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Agmenge$", mo_Tools.DblToScreen(BOR_Agmenge, 2), , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_Manual$", BOR_Manual, , , vbTextCompare)
  as_Text = Replace(as_Text, "$BOR_WghPnt$", BOR_WghPnt, , , vbTextCompare)
  ReplaceValuePlaceholder = as_Text
  Exit Function
ErrHandler:
  Call ErrorHandler("ReplaceValuePlaceholder")
End Function

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub



